/*
Copyright 2008-2011 Broadcom Corporation

This program isthe proprietary software of Broadcom Corporation and/or its
licensors, and may only be used, duplicated, modifiedor distributed pursuant to
the terms and conditions of a separate, written license agreement executed
between you and Broadcom (an "Authorized License"). Except as set forth in an
Authorized License, Broadcom grants no license (express or implied), right to
use, or waiver of any kind with respect to the Software, and Broadcom expressly
reserves all rights in and to the Software and all intellectual property rights
therein. IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS
SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL
USE OF THE SOFTWARE.

Except as expressly set forth in the Authorized License,

1. This program, including its structure, sequence and organization, constitutes
   the valuable trade secrets of Broadcom, and you shall use all reasonable
   efforts to protect the confidentiality thereof, and to use this information
   only in connection with your use of Broadcom integrated circuit products.

2.TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWAREIS PROVIDED "AS IS" AND
   WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
   WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
   THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMSANY AND ALL IMPLIED WARRANTIES
   OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
   LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
   OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
   USE OR PERFORMANCE OF THE SOFTWARE.

3.TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
   LICENSORS BE LIABLE FOR(i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
   EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
   USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
   THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
   ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
   LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
   ANY LIMITED REMEDY.
*/
/** \file error.h
 * \brief Some definitions to handle errors and asserts
 *
 **************************************************/

#ifndef ERROR_H_
#define ERROR_H_

#include <stdio.h>
#include <stdlib.h>
#include "l2_driver.h"

/***************************************************
 *        Public Function Prototypes Section
 ***************************************************/
void trace_byte(const char* msg,TU8* ptr, TU16 size);
void trace(const char* frm, ...);

/***************************************************
 *           Public Defines Section
 ***************************************************/
/** \brief free a pointer if it is not NULL and NULL it afterwards */
#define DELETE(p)      if ( (p) != NULL ) { free(p); p = NULL; }

/** \brief this macro must be used to stop the program execution */
#define FATAL_ERROR() do { \
  printf("error in %s()\n", __func__); exit(EXIT_FAILURE); \
} while(0)

/**\brief this macro must be used to stop the program execution when a condition fails */
#define ASSERTION(boolean) do { \
  if ( !(boolean) ) { printf("assert in %s()\n", __func__); exit(EXIT_FAILURE); } \
} while(0)

/** \brief this macro must be used to stop the program execution when a pointer
           is NULL */
#define CHECK_PTR(pointer) do { \
  if ((pointer) == NULL) { printf("null pointer in %s()\n", __func__); exit(EXIT_FAILURE); } \
} while(0)

/** \brief A macro to trace the program in debug mode */
#define TRACE_MSG(string...) trace(string);

/** \brief A macro to trace an array of bytes */
#define TRACE_BYTE(MSG,PTR, SIZE) trace_byte(MSG,PTR,SIZE);

/** \brief alloc memory and then check to make sure the allocation succeeded */
#define NEW(PTR, TYPE) \
   PTR = calloc(1, sizeof(TYPE));  \
   CHECK_PTR(PTR);

/** \brief alloc memory and then check to make sure the allocation succeeded */
#define NEW_ARRAY(PTR, TYPE, SIZE) \
   PTR = calloc(SIZE, sizeof(TYPE));  \
   CHECK_PTR(PTR);



#endif /*ERROR_H_*/
